/******/ (() => { // webpackBootstrap
var __webpack_exports__ = {};
/*!*********************************************************!*\
  !*** ./resources/js/admin/parts/settings/user_banks.js ***!
  \*********************************************************/
(function ($) {
  "use strict";

  function getModalData(path) {
    loadingSwl();
    $.get(path, function (result) {
      if (result.code === 200) {
        Swal.fire({
          html: result.html,
          showCancelButton: false,
          showConfirmButton: false,
          customClass: {
            content: 'p-0 text-left'
          },
          width: '36rem',
          onOpen: function onOpen() {}
        });
      }
    });
  }
  $('body').on('click', '.js-add-user-banks, .js-edit-user-banks', function () {
    var path = $(this).attr('data-path');
    getModalData(path);
  });
  $('body').on('change', '.js-user-banks-locale', function () {
    var form = $(this).closest('#addUserBankForm');
    var path = form.attr('data-action');
    path = path.replaceAll('update', 'edit');
    path = path + "?locale=" + $(this).val();
    getModalData(path);
  });
  $('body').on('click', '.js-save-bank', function () {
    var $this = $(this);
    var $form = $('#addUserBankForm');
    var data = serializeObjectByTag($form);
    var action = $form.attr('data-action');
    $this.addClass('loadingbar primary').prop('disabled', true);
    $form.find('input').removeClass('is-invalid');
    $form.find('textarea').removeClass('is-invalid');
    $.post(action, data, function (result) {
      if (result && result.code === 200) {
        //window.location.reload();
        Swal.fire({
          icon: 'success',
          html: '<h3 class="font-20 text-center text-dark-blue py-25">' + saveSuccessLang + '</h3>',
          showConfirmButton: false,
          width: '25rem'
        });
        setTimeout(function () {
          window.location.reload();
        }, 500);
      }
    }).fail(function (err) {
      $this.removeClass('loadingbar primary').prop('disabled', false);
      var errors = err.responseJSON;
      if (errors && errors.errors) {
        Object.keys(errors.errors).forEach(function (key) {
          var error = errors.errors[key];
          var element = $form.find('.js-ajax-' + key);
          element.addClass('is-invalid');
          element.parent().find('.invalid-feedback').text(error[0]);
        });
      }
    });
  });
  $('body').on('click', '.js-add-specification', function () {
    var $parent = $('.js-specifications-lists');
    var random = randomString();
    var html = "<div class=\"js-specification-card row align-items-center\">\n                    <div class=\"col-10\">\n                        <div class=\"form-group\">\n                            <label>".concat(specificationLang, "</label>\n                            <input type=\"text\" name=\"specifications[").concat(random, "][name]\" class=\"form-control\">\n                        </div>\n                    </div>\n                    <div class=\"col-2\">\n                        <button type=\"button\" class=\"js-remove-specification btn btn-danger\">\n                            <i class=\"fa fa-trash\"></i>\n                        </button>\n                    </div>\n                </div>");
    $parent.append(html);
  });
  $('body').on('click', '.js-remove-specification', function () {
    $(this).closest('.js-specification-card').remove();
  });
})(jQuery);
/******/ })()
;